package com.qboxus.tictic.viewModels

import android.content.Context
import androidx.fragment.app.Fragment
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import androidx.lifecycle.ViewModelProvider
import androidx.lifecycle.viewModelScope
import com.qboxus.tictic.activitesfragments.DiscoverFragment
import com.qboxus.tictic.activitesfragments.HomeFragment
import com.qboxus.tictic.activitesfragments.location.DeliveryAddress
import com.qboxus.tictic.activitesfragments.profile.ProfileTabFragment
import com.qboxus.tictic.activitesfragments.spaces.SpaceTabF
import com.qboxus.tictic.repositories.AddressRepository
import com.qboxus.tictic.repositories.UserRepository
import com.qboxus.tictic.apiclasses.ApiResponce
import com.qboxus.tictic.mainmenu.BlankFragment
import com.qboxus.tictic.models.UserModel
import com.qboxus.tictic.simpleclasses.Functions
import com.qboxus.tictic.simpleclasses.Variables
import kotlinx.coroutines.launch
import org.json.JSONObject

class MainMenuViewModel(
    private val context: Context,
    private val addressRepository: AddressRepository,
    private val userRepository: UserRepository
) : ViewModel(){

    val _deliveryAddressLiveData: MutableLiveData<ApiResponce<ArrayList<DeliveryAddress>>> = MutableLiveData()
    val deliveryAddressLiveData: LiveData<ApiResponce<ArrayList<DeliveryAddress>>> get() = _deliveryAddressLiveData


    val _userDetailLiveData: MutableLiveData<ApiResponce<UserModel>> = MutableLiveData()
    val userDetailLiveData: LiveData<ApiResponce<UserModel>> get() = _userDetailLiveData



    private val _tabFragments = MutableLiveData<List<Fragment>>()
    val tabFragments: LiveData<List<Fragment>> get() = _tabFragments

    // LiveData to observe tab position
    private val _currentTabPosition = MutableLiveData<Int>()
    val currentTabPosition: LiveData<Int> get() = _currentTabPosition
    init {
        registerFragmentWithPager()
    }


    // Method to initialize fragments and tabs
    private fun registerFragmentWithPager() {
        val fragments = mutableListOf<Fragment>()
        fragments.add(HomeFragment.newInstance()!!)
        fragments.add(DiscoverFragment.newInstance())
        fragments.add(BlankFragment.newInstance())
        fragments.add(SpaceTabF.newInstance())
        fragments.add(ProfileTabFragment.newInstance())


        _tabFragments.value = fragments
    }


    fun getAddressList(){
        viewModelScope.launch {
            val param = JSONObject()
            param.put("user_id",
                Functions.getSharedPreference(context)
                    .getString(Variables.U_ID, "")
            )

            addressRepository.showDeliveryAddresses(param, _deliveryAddressLiveData)
        }
    }

    fun getUserDetails(userId:String){
        viewModelScope.launch {
            val param = JSONObject().apply {
                put(
                    "auth_token", Functions.getSharedPreference(context)
                        .getString(Variables.AUTH_TOKEN, "0")
                )
                put("other_user_id", userId)
            }
            userRepository.showUserDetail(param, _userDetailLiveData)
        }
    }


}


class MainMenuFactory(
    private val context: Context,
    private val addressRepository: AddressRepository,
    private val userRepository: UserRepository
) : ViewModelProvider.Factory {
    override fun <T : ViewModel> create(modelClass: Class<T>): T {
        if (modelClass.isAssignableFrom(MainMenuViewModel::class.java)) {
            return MainMenuViewModel(context,addressRepository,userRepository) as T
        }
        throw IllegalArgumentException("Unknown ViewModel class")
    }
}